/*
 * MPDT_Msg_Parsers.cpp
 *
 *  Created on: Mar 29, 2019
 *      Author: gjd5kor
 */

#define ETG_S_IMPORT_INTERFACE_GENERIC
#define ETG_S_IMPORT_INTERFACE_PLATFORM
#include "etg_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TR_CLASS_FC_MCAN_TCU_UTIL
#include "trcGenProj/Header/MPDT_Msg_Parsers.cpp.trc.h"
#endif

#include "MPDT_Msg_Parsers.h"

#include <fstream>
#include <sstream>
#include <string>

#define BASE_PATH "/opt/bosch/tcu/mcan/json/"

MPDT_Msg_Parsers::MPDT_Msg_Parsers()
{
	// TODO Auto-generated constructor stub

}


MPDT_Msg_Parsers::~MPDT_Msg_Parsers()
{
	// TODO Auto-generated destructor stub
}

tBool MPDT_Msg_Parsers::bGetDataFromFile(Json::Value& oData, std::string sFilePath)
{
	tBool bRetval= FALSE;

	std::ifstream Config(sFilePath.c_str());
	bool loadStatus = false;

	if(Config.good())
	{
		std::ifstream binaryInputData(sFilePath.c_str(), std::ifstream::binary);
		Json::Reader reader;
		loadStatus = reader.parse(binaryInputData, oData, false);

		if(loadStatus == true)
		{
			ETG_TRACE_USR1(("%s file data Loaded to Json Object ",sFilePath.c_str()));
			bRetval = TRUE;
		}
		else
		{
			ETG_TRACE_USR1(("Failed to load the data From file %s ",sFilePath.c_str()));

		}
	}
	else
	{
		ETG_TRACE_USR1(("Failed to load the data From file %s ",sFilePath.c_str()));
	}

	return bRetval;
}

tBool MPDT_Msg_Parsers::bParseAndFillTimeLimitRestriction(Json::Value& oData, TCU_Time_Limit_Restriction& oTCU_Time_Limit_Restriction)
{

	Json::Value oTimeLimit;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,"Time_Limit",oTimeLimit);
	if(TRUE == bParseStatus)
	{
		std::vector<TCU_Time_Slot> oSlots;
		Json::Value oTimeLimits;
		bParseStatus = oParseUtil.getJSONArray(oTimeLimit,"Time_Slot",oTimeLimits);

		if(TRUE == bParseStatus)
		{
			tBool bParseFail = FALSE;
			for(tU16 u16Index = 0;u16Index<oTimeLimits.size();u16Index++)
			{
				TCU_Time_Slot oSlot;
				if(TRUE == bParseAndFillTimeSlot(oTimeLimits[u16Index],oSlot))
				{
					oSlots.push_back(oSlot);
				}
				else
				{
					bParseFail = TRUE;
					break;
				}
			}

			if(TRUE == bParseFail)
			{
				return FALSE;
			}
			else
			{
				oTCU_Time_Limit_Restriction.setListOfTimeSlots(oSlots);
			}
		}
		else
		{
			return FALSE;
		}

	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillTimeSlot(Json::Value& oData, TCU_Time_Slot& oTCU_Time_Slot)
{
	Json::Value oTimeStamp;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,"Start_Time_Stamp",oTimeStamp);
	if(TRUE == bParseStatus)
	{
		TCU_Date_Time oDate_time;
		bParseStatus = bParseAndFillDateTime(oTimeStamp,oDate_time);
		if(TRUE == bParseStatus)
		{
			oTCU_Time_Slot.setStartTimeStamp(oDate_time);
		}
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.getJSONObject(oData,"Stop_Time_Stamp",oTimeStamp);
	if(TRUE == bParseStatus)
	{
		TCU_Date_Time oDate_time;
		bParseStatus = bParseAndFillDateTime(oTimeStamp,oDate_time);
		if(TRUE == bParseStatus)
		{
			oTCU_Time_Slot.setStopTimeStamp(oDate_time);
		}
	}
	else
	{
		return FALSE;
	}

	tU8 u8Val;
	bParseStatus = oParseUtil.gettU8UInt(oData,"Cycle",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Time_Slot.setE8Cycle((MCAN_MsgEnums::enTCU_Cycle)u8Val);
	}
	else
	{
		return FALSE;
	}


	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillDateTime(Json::Value& oData, TCU_Date_Time& oTCU_Date_Time)
{
	tU16 u16Data;
	tBool bParseStatus = oParseUtil.gettU16UInt(oData,"Year",u16Data);

	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU16Year(u16Data);
	}
	else
	{
		return FALSE;
	}

	tU8 u8Val;
	bParseStatus = oParseUtil.gettU8UInt(oData,"Month",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU8Month(u8Val);
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.gettU8UInt(oData,"Day",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU8Day(u8Val);
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.gettU8UInt(oData,"Hour",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU8Hour(u8Val);
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.gettU8UInt(oData,"Minute",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU8Minute(u8Val);
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.gettU8UInt(oData,"Second",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU8Second(u8Val);
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.gettU8UInt(oData,"Reserve",u8Val);
	if(TRUE == bParseStatus)
	{
		oTCU_Date_Time.setU8Reserve(u8Val);
	}
	else
	{
		return FALSE;
	}

	return TRUE;

}

tBool MPDT_Msg_Parsers::bParseAndFillSpeedLimitRestriction(Json::Value& oData, TCU_Speed_Limit_Restriction& oTCU_Speed_Limit_Restriction)
{
	Json::Value oSpeedLimit;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,"Speed_Limit",oSpeedLimit);
	if(TRUE == bParseStatus)
	{
		Json::Value oLimited_VehicleSpeeds;
		bParseStatus = oParseUtil.getJSONArray(oSpeedLimit,"Limited_Vehicle_Speed",oLimited_VehicleSpeeds);
		if(TRUE == bParseStatus)
		{
			std::vector<tU16> oSpeepLimits;
			tBool bParseFail = FALSE;
			for(tU16 u16Index = 0;u16Index<oLimited_VehicleSpeeds.size();u16Index++)
			{
				tU16 u16Val;
				if(TRUE == oParseUtil.gettU16UInt(oLimited_VehicleSpeeds[u16Index],"Value",u16Val))
				{
					oSpeepLimits.push_back(u16Val);
				}
				else
				{
					bParseFail = TRUE;
					break;
				}
			}

			if(TRUE == bParseFail)
			{
				return FALSE;
			}
			else
			{
				oTCU_Speed_Limit_Restriction.setLimitedVehicleSpeed(oSpeepLimits);
			}
		}
		else
		{
			return FALSE;
		}

		Json::Value oTimeSlots;
		bParseStatus = oParseUtil.getJSONArray(oSpeedLimit,"Time_Slot",oTimeSlots);

		if(TRUE == bParseStatus)
		{
			std::vector<TCU_Time_Slot> oTimeSlotsBySpeepLimits;
			tBool bParseFail = FALSE;
			for(tU16 u16Index = 0;u16Index<oTimeSlots.size();u16Index++)
			{
				TCU_Time_Slot oSlot;
				if(TRUE == bParseAndFillTimeSlot(oTimeSlots[u16Index],oSlot))
				{
					oTimeSlotsBySpeepLimits.push_back(oSlot);
				}
				else
				{
					bParseFail = TRUE;
					break;
				}
			}

			if(TRUE == bParseFail)
			{
				return FALSE;
			}
			else
			{
				oTCU_Speed_Limit_Restriction.setListOfTimeSlots(oTimeSlotsBySpeepLimits);
			}

		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillAreaLimitRestriction(Json::Value& oData, TCU_Area_Limit_Restriction& oTCU_Area_Limit_Restriction)
{
	Json::Value oAreaLimit;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,"Area_Limit",oAreaLimit);
	if(TRUE == bParseStatus)
	{
		Json::Value Area_Limit_Restrictions;
		tBool bParseStatus = oParseUtil.getJSONArray(oAreaLimit,"Area_Limit_Restriction",Area_Limit_Restrictions);

		std::vector<Area_Limit_Coordinates> oArea_Limit_CoordinatesList;
		if(TRUE == bParseStatus)
		{
			tBool bParseFail = TRUE;
			for(tU16 u16Index = 0; u16Index <Area_Limit_Restrictions.size(); u16Index++)
			{
				Area_Limit_Coordinates oArea_Limit_Coordinates;

				tU8 u8Val;
				if(TRUE == oParseUtil.gettU8UInt(Area_Limit_Restrictions[u16Index],"Restriction_Area_Type",u8Val))
				{
					oArea_Limit_Coordinates.setE8RestrictionAreaType((MCAN_MsgEnums::enTCU_Restriction_Area_Type)u8Val);
				}
				else
				{
					break;
				}

				if(TRUE == oParseUtil.gettU8UInt(Area_Limit_Restrictions[u16Index],"Area_Form",u8Val))
				{
					oArea_Limit_Coordinates.setE8AreaForm((MCAN_MsgEnums::enTCU_Area_Form)u8Val);
				}
				else
				{
					break;
				}

				if(TRUE == oParseUtil.gettU8UInt(Area_Limit_Restrictions[u16Index],"LocationType",u8Val))
				{
					oArea_Limit_Coordinates.setE8LocationType((MCAN_MsgEnums::enTCU_LocationType)u8Val);
				}
				else
				{
					break;
				}

				Area_Coorinate oCoordinate;
				if(TRUE == bParseAndFillAreaCoordinate(Area_Limit_Restrictions[u16Index],oCoordinate))
				{
					oArea_Limit_Coordinates.setAreaCoordinates(oCoordinate);
				}
				else
				{
					break;
				}

				tU16 u16Val ;
				if(TRUE == oParseUtil.gettU16UInt(Area_Limit_Restrictions[u16Index],"Radius",u16Val))
				{
					oArea_Limit_Coordinates.setU16Radius(u16Val);
				}
				else
				{
					break;
				}

				bParseFail = FALSE;

				oArea_Limit_CoordinatesList.push_back(oArea_Limit_Coordinates);

			}

			if(TRUE == bParseFail)
			{
				return FALSE;
			}
			else
			{
				oTCU_Area_Limit_Restriction.setAreaLimitCoordinates(oArea_Limit_CoordinatesList);
			}

		}
		else
		{
			return FALSE;
		}


		Json::Value oTimeLimits;
		bParseStatus = oParseUtil.getJSONArray(oAreaLimit,"Time_Slot",oTimeLimits);

		if(TRUE == bParseStatus)
		{
			std::vector<TCU_Time_Slot> oSlots;
			tBool bParseFail = FALSE;
			for(tU16 u16Index = 0;u16Index<oTimeLimits.size();u16Index++)
			{
				TCU_Time_Slot oSlot;
				if(TRUE == bParseAndFillTimeSlot(oTimeLimits[u16Index],oSlot))
				{
					oSlots.push_back(oSlot);
				}
				else
				{
					bParseFail = TRUE;
					break;
				}
			}

			if(TRUE == bParseFail)
			{
				return FALSE;
			}
			else
			{
				oTCU_Area_Limit_Restriction.setListOfTimeSlots(oSlots);
			}
		}
		else
		{
			return FALSE;
		}

	}
	else
	{
		return FALSE;
	}
		return TRUE;

	}

	tBool MPDT_Msg_Parsers::bParseAndFillAreaCoordinate(Json::Value& oData, Area_Coorinate& oArea_Coorinate)
	{
		Json::Value Area_Coordinate;
		tBool bParseStatus = oParseUtil.getJSONObject(oData,"Area_Coordinates",Area_Coordinate);
		if(TRUE == bParseStatus)
		{
			TCU_GPS_Position oCordinate;
			if(TRUE == bParseAndFillCordinate(Area_Coordinate,oCordinate,"Coordinates_1"))
		{
			oArea_Coorinate.setCoordinates1(oCordinate);
		}
		else
		{
			return FALSE;
		}

		if(TRUE == bParseAndFillCordinate(Area_Coordinate,oCordinate,"Coordinates_2"))
		{
			oArea_Coorinate.setCoordinates2(oCordinate);
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillCordinate(Json::Value& oData, TCU_GPS_Position& oCordinates, std::string sCordStr)
{
	Json::Value Coordinate;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,sCordStr.c_str(),Coordinate);
	if(TRUE == bParseStatus)
	{
		tU8 u8Val;
		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Lattitude_Mode",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8Latitudemode((MCAN_MsgEnums::enTCU_LatitudeMode)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Longitude_Mode",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8Longtitudemode((MCAN_MsgEnums::enTCU_LongitudeMode)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Lattitude_DEG",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LatitudeDeg(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Lattitude_MIN",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LatitudeMin(u8Val);
		}
		else
		{
			return FALSE;
		}

		tU16 u16Val;
		bParseStatus = oParseUtil.gettU16UInt(Coordinate,"Lattitude_SEC",u16Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU16LatitudeSec(u16Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Longitude_DEG",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LongitudeDeg(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Longitude_MIN",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LongitudeMin(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU16UInt(Coordinate,"Longitude_SEC",u16Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU16LongitudeSec(u16Val);
		}
		else
		{
			return FALSE;
		}

	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillRestrictionSettings(Restriction_Settings& oRestrictionSettings)
{
	Json::Value oVal;
	std::string sFileName(BASE_PATH);
	sFileName.append("Restriction_Settings.json");

	tBool bParseStatus = bGetDataFromFile(oVal,sFileName);
	if(TRUE == bParseStatus)
	{
		TCU_Time_Limit_Restriction oTCU_Time_Limit_Restriction;
		if(TRUE == bParseAndFillTimeLimitRestriction(oVal,oTCU_Time_Limit_Restriction))
		{
			oRestrictionSettings.setTimeLimitRestriction(oTCU_Time_Limit_Restriction);
		}
		else
		{
			return FALSE;
		}

		TCU_Speed_Limit_Restriction oTCU_Speed_Limit_Restriction;

		if(TRUE == bParseAndFillSpeedLimitRestriction(oVal,oTCU_Speed_Limit_Restriction))
		{
			oRestrictionSettings.setSpeedLimitRestriction(oTCU_Speed_Limit_Restriction);
		}
		else
		{
			return FALSE;
		}

		TCU_Area_Limit_Restriction oTCU_Area_Limit_Restriction;

		if(TRUE == bParseAndFillAreaLimitRestriction(oVal,oTCU_Area_Limit_Restriction))
		{
			oRestrictionSettings.setAreaLimitRestriction(oTCU_Area_Limit_Restriction);
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillTCUState(TCUState& oTCUState)
{
	Json::Value oData;
	std::string sFileName(BASE_PATH);
	sFileName.append("TCU_State.json");

	tBool bParseStatus = bGetDataFromFile(oData,sFileName);


	//tBool bParseStatus = oParseUtil.getJSONObject(oTCUState,"TCU_STATE",oTCUState);

	if(TRUE == bParseStatus)
	{
		tU8 u8Val;
		tBool bParseStatus1 = oParseUtil.gettU8UInt(oData,"Modem_Status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8ModemStatus((MCAN_MsgEnums::enTCU_ModemStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"TCU_Status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8TcuStatus((MCAN_MsgEnums::enTCU_TCUStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"GSM_Status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8GsmStatus((MCAN_MsgEnums::enTCU_GSMStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"GSM_RSSI_Level",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setU8GsmrssiLevel(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Wifi_Status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8TcuWifiStatus((MCAN_MsgEnums::enTCU_WifiStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Wifi_Mode",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8TcuWifiMode((MCAN_MsgEnums::enTCU_WifiMode)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Wifi_HotSpot_Status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8WifiHotSpotStatus((MCAN_MsgEnums::enWifiHotSpotStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Wifi_Client_Status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8WifiClientStatus((MCAN_MsgEnums::enWifiClientStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"GSM_Data_Mode",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setE8GsmDataMode((MCAN_MsgEnums::enGSMDataMode)u8Val);
		}
		else
		{
			return FALSE;
		}
		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Wifi_Client_SSID",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setU8WifiClientSsid(u8Val);
		}
		else
		{
			return FALSE;
		}
		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Wifi_Client_Power",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUState.setU8WifiClientPower(u8Val);
		}
		else
		{
			return FALSE;
		}


	}
	else
	{
		return FALSE;
	}

	return TRUE;



}

tBool MPDT_Msg_Parsers::bParseAndFillTCUExtendedStateStatus(TCUExtendedState& oTCUExtendedState)
{
	Json::Value oData;
	std::string sFileName(BASE_PATH);
	sFileName.append("TCU_Extended_State_Status.json");

	tBool bParseStatus = bGetDataFromFile(oData,sFileName);


	if(TRUE == bParseStatus)
	{
		tU8 u8Val;
		tBool bParseStatus1 = oParseUtil.gettU8UInt(oData,"Invalid_Parameter",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setE8InvalidParameter((MCAN_MsgEnums::enInvalidParameter)u8Val);
		}
		else
		{
			return FALSE;
		}
		std::string sIMEINumber;
		bParseStatus1 = oParseUtil.getString(oData,"IMEI",sIMEINumber);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setImeiNumber(sIMEINumber);
		}
		else
		{
			return FALSE;
		}
		std::string sICCIDNumber;
		bParseStatus1 = oParseUtil.getString(oData,"ICC_ID",sICCIDNumber);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setIccId(sICCIDNumber);
		}
		else
		{
			return FALSE;
		}

		tU16 u16Data;
		bParseStatus1 = oParseUtil.gettU16UInt(oData,"MCC",u16Data);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setU16Mcc(u16Data);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"MNC",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setU8Mnc(u8Val);
		}
		else
		{
			return FALSE;
		}

		std::string sMobile_Network_Name;
		bParseStatus1 = oParseUtil.getString(oData,"Mobile Network Name",sMobile_Network_Name);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setMobileNetworkName(sMobile_Network_Name);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Roaming status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setE8RoamingStatus((MCAN_MsgEnums::enTCU_RoamingStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"PPP connection status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setE8PppConnectionStatus((MCAN_MsgEnums::enTCU_PPPConnectionStatus)u8Val);
		}
		else
		{
			return FALSE;
		}
	}

	else
	{
		return FALSE;
	}

	return TRUE;

}

tBool MPDT_Msg_Parsers::bParseAndFillTCUExtendedStateIndication(TCUExtendedState& oTCUExtendedState)
{
	Json::Value oData;
	std::string sFileName(BASE_PATH);
	sFileName.append("TCU_Extended_State_Indication.json");

	tBool bParseStatus = bGetDataFromFile(oData,sFileName);


	if(TRUE == bParseStatus)
	{

		std::string sIMEINumber;
		tBool bParseStatus1 = oParseUtil.getString(oData,"IMEI",sIMEINumber);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setImeiNumber(sIMEINumber);
		}
		else
		{
			return FALSE;
		}
		std::string sICCIDNumber;
		bParseStatus1 = oParseUtil.getString(oData,"ICC_ID",sICCIDNumber);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setIccId(sICCIDNumber);
		}
		else
		{
			return FALSE;
		}

		tU16 u16Data;
		bParseStatus1 = oParseUtil.gettU16UInt(oData,"MCC",u16Data);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setU16Mcc(u16Data);
		}
		else
		{
			return FALSE;
		}
		tU8 u8Val;
		bParseStatus1 = oParseUtil.gettU8UInt(oData,"MNC",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setU8Mnc(u8Val);
		}
		else
		{
			return FALSE;
		}

		std::string sMobile_Network_Name;
		bParseStatus1 = oParseUtil.getString(oData,"Mobile Network Name",sMobile_Network_Name);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setMobileNetworkName(sMobile_Network_Name);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"Roaming status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setE8RoamingStatus((MCAN_MsgEnums::enTCU_RoamingStatus)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus1 = oParseUtil.gettU8UInt(oData,"PPP connection status",u8Val);
		if(TRUE == bParseStatus1)
		{
			oTCUExtendedState.setE8PppConnectionStatus((MCAN_MsgEnums::enTCU_PPPConnectionStatus)u8Val);
		}
		else
		{
			return FALSE;
		}
	}

	else
	{
		return FALSE;
	}

	return TRUE;

}

tBool MPDT_Msg_Parsers::bParseAndFillNaviVehicleSpeed(Json::Value& oData, Navi_Vehicle_Speed& oNavi_Vehicle_Speed)
{
	tU16 u16Data;
	tBool bParseStatus = oParseUtil.gettU16UInt(oData,"Navi_Vehicle_Speed",u16Data);

	if(TRUE == bParseStatus)
	{
		oNavi_Vehicle_Speed.setU16NaviVehicleSpeed(u16Data);
	}
	else
	{
		return FALSE;
	}
	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillNaviDrivingDistance(Json::Value& oData, Navi_Driving_Distance& oNavi_Driving_Distance)
{
	tU32 u32Data;
	tBool bParseStatus = oParseUtil.gettU32UInt(oData,"Navi_Driving_Distance",u32Data);

	if(TRUE == bParseStatus)
	{
		oNavi_Driving_Distance.setU32NaviDrivingDistance(u32Data);
	}
	else
	{
		return FALSE;
	}
	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillNaviRoadClassification(Json::Value& oData, Navi_Road_Classification& oNavi_Road_Classification)
{
	tU8 u8Val;
	tBool bParseStatus = oParseUtil.gettU8UInt(oData,"Road_Type",u8Val);

	if(TRUE == bParseStatus)
	{
		oNavi_Road_Classification.setU8RoadTypeInformation(u8Val);
	}
	else
	{
		return FALSE;
	}

	bParseStatus = oParseUtil.gettU8UInt(oData,"Table_Type",u8Val);

	if(TRUE == bParseStatus)
	{
		oNavi_Road_Classification.setU8DestinationTableInformation(u8Val);
	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillProbevehicleInfo(Probe_Vehicle_Info& oProbe_Vehicle_Info)
{
	Json::Value oVal;
	std::string sFileName(BASE_PATH);
	sFileName.append("Probe_Vehicle_Info.json");

	tBool bParseStatus = bGetDataFromFile(oVal,sFileName);


	if(TRUE == bParseStatus)
	{
		Navi_Vehicle_Speed oNavi_Vehicle_Speed;
		if(TRUE == bParseAndFillNaviVehicleSpeed(oVal,oNavi_Vehicle_Speed))
		{
			oProbe_Vehicle_Info.setNaviVehicleSpeed(oNavi_Vehicle_Speed);
		}
		else
		{
			return FALSE;
		}

		Navi_Driving_Distance oNavi_Driving_Distance;
		if(TRUE == bParseAndFillNaviDrivingDistance(oVal,oNavi_Driving_Distance))
		{
			oProbe_Vehicle_Info.setNaviDrivingDistance(oNavi_Driving_Distance);
		}
		else
		{
			return FALSE;
		}

		Navi_Road_Classification oNavi_Road_Classification;
		if(TRUE == bParseAndFillNaviRoadClassification(oVal,oNavi_Road_Classification))
		{
			oProbe_Vehicle_Info.setNaviRoadClassification(oNavi_Road_Classification);
		}
		else
		{
			return FALSE;
		}

	}
	else
	{
		return FALSE;
	}

	return TRUE;

}

tBool MPDT_Msg_Parsers::bParseAndFillLocationInfo(Json::Value& oData, TCU_Location_Info& oCordinates, std::string sCordStr)
{
	Json::Value Coordinate;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,sCordStr.c_str(),Coordinate);
	if(TRUE == bParseStatus)
	{
		tU8 u8Val;

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Location_Type",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8LocationType((MCAN_MsgEnums::enTCU_LocationType)u8Val);
		}
		else
		{
			return FALSE;
		}


		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Lattitude_Mode",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8Latitudemode((MCAN_MsgEnums::enTCU_LatitudeMode)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Longitude_Mode",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8Longtitudemode((MCAN_MsgEnums::enTCU_LongitudeMode)u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Lattitude_DEG",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LatitudeDeg(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Lattitude_MIN",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LatitudeMin(u8Val);
		}
		else
		{
			return FALSE;
		}

		tU16 u16Val;
		bParseStatus = oParseUtil.gettU16UInt(Coordinate,"Lattitude_SEC",u16Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU16LatitudeSec(u16Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Longitude_DEG",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LongitudeDeg(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Longitude_MIN",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8LongitudeMin(u8Val);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU16UInt(Coordinate,"Longitude_SEC",u16Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU16LongitudeSec(u16Val);
		}
		else
		{
			return FALSE;
		}

		Altitude oAltitude;
		//bParseStatus = oParseUtil.gettU16UInt(Coordinate,"Altitude",u16Val);
		if(TRUE == bParseAndFillAltitude(Coordinate,oAltitude,"Altitude"))
		{

			oCordinates.setAltitude(oAltitude);
		}
		else
		{
			return FALSE;
		}

		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Satellite_Number",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8SatelliteNumber(u8Val);
		}
		else
		{
			return FALSE;
		}
		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Home",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8Home((MCAN_MsgEnums::enTCU_Home)u8Val);
		}
		else
		{
			return FALSE;
		}
		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Reserve",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU8Reserved(u8Val);
		}
		else
		{
			return FALSE;
		}


	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillAltitude(Json::Value& oData, Altitude& oCordinates, std::string sCordStr)
{
	Json::Value Coordinate;
	tBool bParseStatus = oParseUtil.getJSONObject(oData,sCordStr.c_str(),Coordinate);
	if(TRUE == bParseStatus)
	{
		tU8 u8Val;
		bParseStatus = oParseUtil.gettU8UInt(Coordinate,"Sign",u8Val);
		if(TRUE == bParseStatus)
		{
			oCordinates.setE8Sign((MCAN_MsgEnums::enTCU_AltitudeSign)u8Val);
		}
		else
		{
			return FALSE;
		}

		tU16 u16Data;
		bParseStatus = oParseUtil.gettU16UInt(Coordinate,"Value",u16Data);
		if(TRUE == bParseStatus)
		{
			oCordinates.setU16Value(u16Data);
		}
		else
		{
			return FALSE;
		}

	}
	else
	{
		return FALSE;
	}
	return TRUE;

}
tBool MPDT_Msg_Parsers::bParseAndFillNaviInfo(Navi_Info& oNavi_Info)
{
	Json::Value oVal;
	std::string sFileName(BASE_PATH);
	sFileName.append("Navi_Info.json");

	tBool bParseStatus = bGetDataFromFile(oVal,sFileName);


	if(TRUE == bParseStatus)
	{
		TCU_Location_Info oLocationInfo;
		if(TRUE == bParseAndFillLocationInfo(oVal,oLocationInfo,"Location_Info"))
		{
			oNavi_Info.setLocationInfo(oLocationInfo);
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}

	return TRUE;

}

tBool MPDT_Msg_Parsers::bParseAndFillAreaLimitIndication(Area_Limit& oArea_Limit)
{
	Json::Value oVal;
	std::string sFileName(BASE_PATH);
	sFileName.append("Area_limit.json");

	tBool bParseStatus = bGetDataFromFile(oVal,sFileName);
	Json::Value Area_Limit_Indication;
	bParseStatus = oParseUtil.getJSONObject(oVal,"Area_Limit_Coordinates",Area_Limit_Indication);

	if(TRUE == bParseStatus)
	{
		//tBool bParseFail = TRUE;
		Area_Limit_Coordinates oArea_Limit_Coordinates;

		tU8 u8Val;
		if(TRUE == oParseUtil.gettU8UInt(Area_Limit_Indication ,"Restriction_Area_Type",u8Val))
		{
			oArea_Limit_Coordinates.setE8RestrictionAreaType((MCAN_MsgEnums::enTCU_Restriction_Area_Type)u8Val);
		}
		else
		{
			return FALSE;
		}

		if(TRUE == oParseUtil.gettU8UInt(Area_Limit_Indication ,"Area_Form",u8Val))
		{
			oArea_Limit_Coordinates.setE8AreaForm((MCAN_MsgEnums::enTCU_Area_Form)u8Val);
		}
		else
		{
			return FALSE;
		}

		if(TRUE == oParseUtil.gettU8UInt(Area_Limit_Indication ,"LocationType",u8Val))
		{
			oArea_Limit_Coordinates.setE8LocationType((MCAN_MsgEnums::enTCU_LocationType)u8Val);
		}
		else
		{
			return FALSE;
		}

		Area_Coorinate oCoordinate;
		if(TRUE == bParseAndFillAreaCoordinate(Area_Limit_Indication ,oCoordinate))
		{
			oArea_Limit_Coordinates.setAreaCoordinates(oCoordinate);
		}
		else
		{
			return FALSE;
		}

		tU16 u16Val ;
		if(TRUE == oParseUtil.gettU16UInt(Area_Limit_Indication ,"Radius",u16Val))
		{
			oArea_Limit_Coordinates.setU16Radius(u16Val);
		}
		else
		{
			return FALSE;
		}


		oArea_Limit.setAreaLimitCoordinates(oArea_Limit_Coordinates);
	}
	else
	{
		return FALSE;
	}


	Json::Value oTimeLimits;
	bParseStatus = oParseUtil.getJSONObject(oVal,"Time_Slot",oTimeLimits);

	if(TRUE == bParseStatus)
	{
		//tBool bParseFail = FALSE;

		TCU_Time_Slot oSlot;
		if(TRUE == bParseAndFillTimeSlot(oTimeLimits,oSlot))
		{
		oArea_Limit.setTimeSlot(oSlot);
		}
		else
		{
			return FALSE;
		}

	}
	else
	{
		return FALSE;
	}

	return TRUE;
}

tBool MPDT_Msg_Parsers::bParseAndFillTimeLimitIndication(Time_Limit& oTime_Limit)
{
	Json::Value oVal;
	std::string sFileName(BASE_PATH);
	sFileName.append("Time_limit.json");

	tBool bParseStatus = bGetDataFromFile(oVal,sFileName);

	Json::Value oTimeLimits;
	bParseStatus = oParseUtil.getJSONObject(oVal,"Time_Slot",oTimeLimits);

	if(TRUE == bParseStatus)
	{
		//tBool bParseFail = FALSE;

		TCU_Time_Slot oSlot;
		if(TRUE == bParseAndFillTimeSlot(oTimeLimits,oSlot))
		{
			oTime_Limit.setTimeSlot(oSlot);
		}
		else
		{
			return FALSE;
		}


	}
	else
	{
		return FALSE;
	}


	return TRUE;

}

tBool MPDT_Msg_Parsers::bParseAndFillSpeedLimitIndication(Speed_Limit& oSpeed_Limit)
{
	Json::Value oVal;
	std::string sFileName(BASE_PATH);
	sFileName.append("Speed_limit.json");

	tBool bParseStatus = bGetDataFromFile(oVal,sFileName);
	if(TRUE == bParseStatus)
	{
		tU16 u16Val ;
		if(TRUE == oParseUtil.gettU16UInt(oVal ,"Limited_Vehicle_Speed",u16Val))
		{
			oSpeed_Limit.setU16LimitedVehicleSpeed(u16Val);
		}
		else
		{
			return FALSE;
		}
	}
	else
	{
		return FALSE;
	}

	Json::Value oTimeLimits;
	bParseStatus = oParseUtil.getJSONObject(oVal,"Time_Slot",oTimeLimits);

	if(TRUE == bParseStatus)
	{
		//tBool bParseFail = FALSE;

		TCU_Time_Slot oSlot;
		if(TRUE == bParseAndFillTimeSlot(oTimeLimits,oSlot))
		{
			oSpeed_Limit.setTimeSlot(oSlot);
		}
		else
		{
			return FALSE;
		}


	}
	else
	{
		return FALSE;
	}


	return TRUE;
}
